#!/usr/bin/env python
"""
A simple UDP sender for the CAN-ETH gateway.
"""
# Copyright (c) 2016 proconX Pty Ltd. All rights reserved.
#
# The following source file constitutes example program code and is
# intended merely to illustrate useful programming techniques.  The user
# is responsible for applying the code correctly.
#
# THIS SOFTWARE IS PROVIDED BY PROCONX AND CONTRIBUTORS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL PROCONX OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import socket
from canethlib import *


CANETH_IP   = "169.254.0.10" # Use '<broadcast>' for broadcasts


def main():
    """Send a single CAN message"""
    msg = CanMsg(0x123, (0x11, 0x22, 0x33, 0x44, 0x55, 0x66, 0x77, 0x88))
    frame = CanEthFrame()
    frame.append(msg)
    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_BROADCAST, 1);
    sock.sendto(frame.pack(), (CANETH_IP, CANETH_PORT))
    print 'CAN message sent %07X:' % (msg.id),
    print ' '.join(format(byte, '02X') for byte in msg)


if __name__ == "__main__":
    main()
