#!/usr/bin/env python
"""
A simple UDP receiver for the CAN-ETH gateway.
"""
# Copyright (c) 2016 proconX Pty Ltd. All rights reserved.
#
# The following source file constitutes example program code and is
# intended merely to illustrate useful programming techniques.  The user
# is responsible for applying the code correctly.
#
# THIS SOFTWARE IS PROVIDED BY PROCONX AND CONTRIBUTORS ``AS IS'' AND ANY
# EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
# PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL PROCONX OR CONTRIBUTORS BE
# LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
# CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
# SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
# BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
# WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
# OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF
# ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import socket
from canethlib import *


def main():
    """A simple receive loop which logs received messages."""
    sock = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    sock.setsockopt(socket.SOL_SOCKET, socket.SO_REUSEADDR, 1)
    sock.bind(('', CANETH_PORT))
    while True:
        datagram, addr = sock.recvfrom(CanEthFrame.MAX_DATAGRAM)
        if datagram:
            print "UDP datagram received from CAN-ETH %s" % addr[0]
            for msg in CanEthFrame(datagram):
                print 'CAN message %07X:' % (msg.id),
                print ' '.join(format(byte, '02X') for byte in msg)


if __name__ == "__main__":
    main()

